/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.altar.IBloodAltar;
import wayoftime.bloodmagic.util.helper.PlayerHelper;
import wayoftime.bloodmagic.util.helper.PlayerSacrificeHelper;

public class ItemBloodProvider
extends Item {
    protected final String tooltipBase;
    public final int lpProvided;

    public ItemBloodProvider(String name, int lpProvided) {
        super(new Item.Properties().m_41487_(64).m_41491_(BloodMagic.TAB));
        this.tooltipBase = "tooltip.bloodmagic.blood_provider." + name + ".";
        this.lpProvided = lpProvided;
    }

    public ItemBloodProvider(String name) {
        this(name, 0);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (PlayerHelper.isFakePlayer(player)) {
            return super.m_7203_(world, player, hand);
        }
        IBloodAltar altarEntity = PlayerSacrificeHelper.getAltar(world, player.m_142538_());
        if (altarEntity != null) {
            double posX = player.m_20185_();
            double posY = player.m_20186_();
            double posZ = player.m_20189_();
            world.m_6263_(player, posX, posY, posZ, SoundEvents.f_11983_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, posX + Math.random() - Math.random(), posY + Math.random() - Math.random(), posZ + Math.random() - Math.random(), 0.0, 0.0, 0.0);
            }
            if (!world.f_46443_ && PlayerHelper.isFakePlayer(player)) {
                return super.m_7203_(world, player, hand);
            }
            altarEntity.fillMainTank(this.lpProvided);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
        }
        return super.m_7203_(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent(this.tooltipBase + "desc").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

